#include <stdio.h>
#include <math.h>
#include <string.h>
#include <allegro.h>
#include "vars.h"
#include "init.h"
#include "timer.h"
#include "sprites.h"
#include "hscore.h"
#include "sounds.h"


extern char *key_names[];

void free_playing_vars(void) {
   int i;

   for (i = 0; i < nb_max_balls; ++i) {
      free(ball[i]);
   }
   free(ball);

   
   for (i = 0; i < 2; ++i) { //ON PREND LES JOUEURS UN PAR UN
      free(player[i]->racket);//une seule raquette  librer
      free(player[i]);
   }
   free(player);     //les joueurs

   free(stars.star); //les toiles

   free(spark);      //les tincelles
   
   return;
}


void free_vars(void) {
   fprintf(fp, "Destroying game data...");
   unload_datafile(data_sprite);
   unload_datafile(data_sfx);
   unload_datafile(data_fonts);

   
   if (draw_method == DOUBLE_BUFFER)
      destroy_bitmap(buffer);
   else if (draw_method == TRIPLE_BUFFER) {
      destroy_bitmap(page1);
      destroy_bitmap(page2);
      destroy_bitmap(page3);
   }
   else if (draw_method == PAGE_FLIPPING) {
      destroy_bitmap(page1);
      destroy_bitmap(page2);
   }

   //le tableau high score de chaque niveau
   free(l_classic.high_score.high_score_entry);
   free(l_hard.high_score.high_score_entry);
   free(l_unlimited.high_score.high_score_entry);
   
   free_menu(option_menu);
   free_menu(main_menu);
   free_menu(mode_selector_menu);
   fprintf(fp, "Done!\n");
   fclose(fp);

   return;
}

void free_menu(TPONG_MENU* menu) {
   
   free(menu->element);
   free(menu);
   
   return;
}

int init_game(void) {
   //pour les futurs randoms
   srand(time(NULL));
   fprintf(fp, "Initialisation...\n");
   if (run_allegro() == FALSE)
      return FALSE;
   //il faut charger les graphismes APRES etre pass en mode vido definitif
   else if (load_game_data() == FALSE)
      return FALSE;

   if (create_menu() == FALSE)
      return FALSE;

   init_levels();



   load_options();  
 
   fprintf(fp, "Game has been successfully initialized!\n");
   return TRUE;
}
   


int run_allegro(void) {
   char buf[256];
   allegro_init();

   if (load_config_options() == FALSE)
      return FALSE;

   install_keyboard();
   
   init_timer();//on initialise le timer du jeu

   sprintf(buf, "TPong " TPONG_VERSION);
   
   fprintf(fp, "Allegro version : %s\n", ALLEGRO_VERSION_STR);

   set_window_title(buf);//ca marche pour $windows$ en tout cas...
   //set_window_close_button(0);
   
   if (init_video(draw_method, gfx_w, gfx_h, color_depth, WINDOWED) == FALSE)
      return FALSE;

   if (sfx_on == TRUE)
      init_sound();

   //On autorise le bouton d'arret sur les plateformes qui le veulent bien
   set_window_close_hook(&function_close_window);
   close_state = FALSE;
   
   return TRUE;
}


int init_video(int config_draw_method, int resol_x, int resol_y, int color_depth, int WINDOWED_MODE) {
   int gfx_mode;

   
   if (WINDOWED_MODE == TRUE) {
      gfx_mode = GFX_AUTODETECT_WINDOWED;
      color_depth = desktop_color_depth();
      if (color_depth < 16) {
         color_depth = 16;
         fprintf(fp, "You shouldn't play with a 8bpp desktop window!\n");
      }
   }
   else 
      gfx_mode = GFX_AUTODETECT_FULLSCREEN;

   set_color_depth(color_depth);

   if (set_gfx_mode(gfx_mode, resol_x, resol_y, 0, 0) != 0) {
      sprintf(pong_error, "%s", allegro_error);      
      return FALSE;
   }
   else
      fprintf(fp, "GFX Driver : %s (%d*%d*%d)\n", gfx_driver->name, SCREEN_W, SCREEN_H, color_depth);

   //on initialise la vido   
   
   if (config_draw_method == TRIPLE_BUFFER)
      enable_triple_buffer();

   if (gfx_capabilities & GFX_CAN_TRIPLE_BUFFER && config_draw_method == TRIPLE_BUFFER)
      draw_method = TRIPLE_BUFFER;
   else if (!(gfx_capabilities & GFX_CAN_TRIPLE_BUFFER) && config_draw_method == TRIPLE_BUFFER)
      draw_method = DOUBLE_BUFFER;
   else
      draw_method = config_draw_method;


   
   if (draw_method == TRIPLE_BUFFER) {
      page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
      page2 = create_video_bitmap(SCREEN_W, SCREEN_H);
      page3 = create_video_bitmap(SCREEN_W, SCREEN_H);
      if ((!page1) || (!page2) || (!page3)) {
         fprintf(fp, "Not enough memory to create three video pages!\n");
         draw_method = DOUBLE_BUFFER;//on passe au mode par dfaut
      }
      else  //si c'est bon:
         fprintf(fp, "Drawing mode : Triple buffering\n");
   }

   if (draw_method == PAGE_FLIPPING) {
      page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
      page2 = create_video_bitmap(SCREEN_W, SCREEN_H);
      if ((!page1) || (!page2)) {
         fprintf(fp, "Not enough memory to enable page flipping!\n");
         draw_method = DOUBLE_BUFFER;//on passe au mode par dfaut
      }
      else  //si c'est bon:
         fprintf(fp, "Drawing mode : Page flipping\n");

   }

   if (draw_method == DOUBLE_BUFFER) {
      buffer = create_bitmap(SCREEN_W, SCREEN_H);
      fprintf(fp, "Drawing mode : Double buffering\n");
      if (ENABLE_VSYNC == TRUE)
         fprintf(fp, "VSync is activated\n");
      else
         fprintf(fp, "VSync is NOT activated\n");
   }
   
   //bon pour la video
   return TRUE;
}

int load_game_data(void) {
   
   data_sprite = load_datafile("data/sprites.dat");
   if (data_sprite == NULL) {
      fprintf(fp, "Unable to find the file: data//sprites.dat\n");
      sprintf(pong_error, "Unable to find \"data//sprites.dat\" !");
      return FALSE;
   }
   else 
      fprintf(fp, "Opening the file : data//sprites.dat\n");

   data_sfx = load_datafile("data/sfx.dat");
   if (data_sfx == NULL) {
      fprintf(fp, "Unable to find the file: data//sfx.dat\n");
      sprintf(pong_error, "Unable to find \"data//sfx.dat\" !");
      return FALSE;
   }
   else 
      fprintf(fp, "Opening the file : data//sfx.dat\n");

   data_fonts = load_datafile("data//fonts.dat");
   if (data_fonts == NULL) {
      fprintf(fp, "Unable to find the file: data//fonts.dat\n");
      sprintf(pong_error, "Unable to find \"data//fonts.dat\" !");
      return FALSE;
   }
   else 
      fprintf(fp, "Opening the file : data//fonts.dat\n");

   return TRUE;
}

  
   
int load_config_options(void) {
   set_config_file("config//config.ini");   
   fprintf(fp, "Loading game configuration\n");
   
   //graphics
   draw_method = get_config_int("gfx", "method", 0);
   
   if (draw_method == 0) {
      fprintf(fp, "Config.ini : file corrupted! \n");
      sprintf(pong_error, "The file \"config//config.ini\" is corrupted!");
      return FALSE;
   }
   
   //on hardcode tout a pour la version finale!
   gfx_w = 320;
   gfx_h = 240;
   color_depth = get_config_int("gfx", "depth", 16);
   WINDOWED = get_config_int("gfx", "windowed", 0);
   
   if (WINDOWED == 0)
      WINDOWED = FALSE;
   else
      WINDOWED = TRUE;

   ENABLE_VSYNC = get_config_int("gfx", "enable_vsync", 0);
   
   if (ENABLE_VSYNC == 0)
      ENABLE_VSYNC = FALSE;
   else
      ENABLE_VSYNC = TRUE;

   
   //timer
//   game_speed = (double)get_config_float("timer", "game_speed", 1);

   //sfx
   sfx_on = get_config_int("sfx", "sounds", 1);
   if (sfx_on == 1)
      sfx_on = TRUE;
   else
      sfx_on = FALSE;

   reverse_stereo = get_config_int("sfx", "reverse", 0);//TRUE si on inverse la stro sinon FALSE.
   if (reverse_stereo == 1)
      reverse_stereo = TRUE;
   else
      reverse_stereo = FALSE;


   sfx_volume = get_config_int("sfx", "sfx_volume", 200);

   
   return TRUE;
}

int init_new_game(int g_type) {//initialise un nouveau jeu
   int i;

   fprintf(fp, "New game initialisation...\n");
   fprintf(fp, "Game type : ");
   if (g_type == DUEL)
      fprintf(fp, "Human vs Computer\n");
   else if (g_type == DUEL_2AI)
      fprintf(fp, "Computer vs Computer\n");
   else if (g_type == DUEL_2P)
      fprintf(fp, "Human vs Human\n");
   else if (g_type == DUEL_2P_VS_AI)
      fprintf(fp, "Two Humans vs Computer\n");
      
   //il faut allouer les variables ncssaires
   set_config_file("config//game.ini");   
   
   nb_max_balls = get_config_int("main", "nb_max_balls", 1);
   nb_max_balls = 1;//TEMPORAIRE POUR LA DEMO
   
   if (nb_max_balls == 0)
      return FALSE;

   if (g_type == DUEL_2P_VS_AI)
      nb_max_players = 3;           //Trois joueurs dans ce mode
   else
      nb_max_players = 2;//On joue que a DEUX pour l'instant! (un  gauche et un autre  droite)

      
   ball = malloc(nb_max_balls*sizeof(BALL*));
   for (i = 0; i < nb_max_balls; ++i) {
      ball[i] = malloc(sizeof(BALL));
      ball[i]->bitmap = ((BITMAP*)(data_sprite[BALL_BMP].dat));
      ball[i]->EXIST = FALSE;//pour l'instant, on les met en veilleuse
   }


   player = malloc(nb_max_players*sizeof(PLAYER*)); //DEUX JOUEURS
   for (i = 0; i < nb_max_players; ++i) { //ON PREND LES JOUEURS UN PAR UN
      player[i] = malloc(sizeof(PLAYER));//ON ALLOUE LA RAM GLOBALE
      player[i]->racket = malloc(sizeof(RACKET)); //le tableau de rzquettes
      
      

      //Par dfaut, la couleur de la raquette est normale
      player[i]->racket->main_bitmap = ((BITMAP*)(data_sprite[RACKET_REGULAR_BMP].dat));
      player[i]->racket->top_bitmap = ((BITMAP*)(data_sprite[RACKET_REGULAR_T_BMP].dat));
      player[i]->racket->bottom_bitmap = ((BITMAP*)(data_sprite[RACKET_REGULAR_B_BMP].dat));
   }
   
   //maintenant, on initialise tout le bordel!
   //on cre les balles!
   for (i = 0; i < nb_max_balls; ++i) {
      init_new_ball(ball[i]); //on active la balle initialise
   }
   nb_current_balls = nb_max_balls;
   
   
   //On Initialise les tincelles
   
   spark = malloc(sizeof(SPARK)*NB_MAX_SPARKS);
   for (i = 0; i < NB_MAX_SPARKS; ++i)
      spark[i].EXIST = FALSE;
   
   game_type = g_type; //on commence un duel classique

   switch (game_type){
      case DUEL:
         player[0]->state = HUMAN;
         player[0]->pos = LEFT;
         player[0]->key_up = single_player.key_up;
         player[0]->key_down = single_player.key_down;
         player[0]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat);
         player[0]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat);
         player[0]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_B_BMP].dat);
         
         player[1]->state = AI;
         player[1]->pos = RIGHT;
         break;
      case DUEL_2AI:
         player[0]->state = AI;
         player[0]->pos = LEFT;
         player[0]->score = 0;
         player[0]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat);
         player[0]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat);
         player[0]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_B_BMP].dat);
         
         
         player[1]->state = AI;
         player[1]->pos = RIGHT;
         player[1]->score = 0;
         player[1]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_RED_BMP].dat);
         player[1]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat);
         player[1]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_RED_B_BMP].dat);
         
         break;
      case DUEL_2P:
         player[0]->state = HUMAN;
         player[0]->pos = RIGHT;
         player[0]->key_up = right_player.key_up;
         player[0]->key_down = right_player.key_down;
         player[0]->score = 0;
         player[0]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_RED_BMP].dat);         
         player[0]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat);
         player[0]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_RED_B_BMP].dat);
         

         player[1]->state = HUMAN;
         player[1]->pos = LEFT;
         player[1]->key_up = left_player.key_up;
         player[1]->key_down = left_player.key_down;
         player[1]->score = 0;
         player[1]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat);         
         player[1]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat);
         player[1]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_B_BMP].dat);
         
         break;
      case DUEL_2P_VS_AI:      
         player[0]->state = HUMAN;
         player[0]->pos = LEFT;
         player[0]->key_up = right_player.key_up;
         player[0]->key_down = right_player.key_down;
         player[0]->score = 0;
         player[0]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_RED_BMP].dat);         
         player[0]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_RED_T_BMP].dat);
         player[0]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_RED_B_BMP].dat);
         

         player[1]->state = HUMAN;
         player[1]->pos = LEFT;
         player[1]->key_up = left_player.key_up;
         player[1]->key_down = left_player.key_down;
         player[1]->score = 0;
         player[1]->racket->main_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_BMP].dat);
         player[1]->racket->top_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_T_BMP].dat);
         player[1]->racket->bottom_bitmap = (BITMAP*)(data_sprite[RACKET_BLUE_B_BMP].dat);
         
         
         player[2]->state = AI;
         player[2]->pos = RIGHT;
         player[2]->score = 0;
         break;         
      default:
         break;
   }

   game_info.winning_side = NOT_DEFINED; //on met que ce n'est pas encore dfini
   game_info.last_score = NOT_DEFINED; //on met que ce n'est pas encore dfini
   game_info.nb_left_wins = 0;   //juste le nombre de manches remportes...
   game_info.nb_right_wins = 0;
   
   for (i = 0; i < nb_max_players; ++i) {
      init_new_racket(player[i]->racket, player[i]);
   }
   
   // On intialise les effets spciaux!
   stars = initialize_stars();
   
   
   return TRUE;
}
   
void init_new_ball(BALL *p_ball) {   
   //VALEUR ARBITRAIRE POUR LE JEU
   p_ball->speed.x = START_BALL_SPEED_X;
   p_ball->speed.y = START_BALL_SPEED_Y;
   p_ball->position.x = START_BALL_X;
   p_ball->position.y = START_BALL_Y;
   p_ball->next_side_to_hit = FIRST_SIDE_TO_HIT;
   p_ball->EXIST = TRUE;
   return;
}

void init_new_random_ball(BALL *p_ball, int state) {
   double angle;
   
   angle = rand()%(int)(PI*100);
   p_ball->speed.x = cos(angle)*0.25;
   p_ball->speed.y = sin(angle)*0.25;
   p_ball->position.x = rand()%(SCREEN_W-(p_ball->bitmap)->w) + (p_ball->bitmap)->w/2;
   p_ball->position.y = rand()%(SCREEN_H-(p_ball->bitmap)->h) + (p_ball->bitmap)->h/2;
   p_ball->EXIST = state;
   return;
}

void init_new_racket(RACKET *p_racket, PLAYER* p_player) {
   
   p_racket->speed.x = 0;
   p_racket->speed.y = 0;
   if (p_player->pos == LEFT)
      p_racket->position.x = INTERVAL_RACKET_X+p_racket->main_bitmap->w/2;
   else if (p_player->pos == RIGHT)
      p_racket->position.x = SCREEN_W-(INTERVAL_RACKET_X+p_racket->main_bitmap->w/2);
   
	p_racket->circle_radius = (p_racket->top_bitmap->w)/2;          //Le rayon des deux cercles qui composent la raquette
   p_racket->circle_centre_interval = (p_racket->main_bitmap->h+1)/2;          //Le rayon des deux cercles qui composent la raquette	
  
   
   
   p_racket->position.y = SCREEN_H/2;
   p_racket->IS_WAITING_FOR_PITCH = FALSE;
      
   return;
}

//Special pour la MINI version :)
#define OFFSET_MENU -20

int create_menu(void) {
   //On commence par le main menu!
   
   main_menu = malloc(sizeof(TPONG_MENU));
   if (!main_menu) {
      fprintf(fp, "Not enough RAM to create a menu!\n");
      return FALSE;
   }
   main_menu->nb_elements = MENU_NB_SELECTIONS;
   main_menu->cur_selection = 0;

   main_menu->element = malloc(sizeof(TPONG_MENU_ELEMENT)*main_menu->nb_elements);
   if (!main_menu->element) {
      fprintf(fp, "Not enough RAM to create menu's elements!\n");
      return FALSE;
   }
   
   strcpy(main_menu->element[MENU_NEW_GAME_DUEL_CLASSIC].name, "Human vs Computer");
   strcpy(main_menu->element[MENU_NEW_GAME_DUEL_CLASSIC].des,"You may as well play against a bloody brick wall!");
   main_menu->element[MENU_NEW_GAME_DUEL_CLASSIC].pos.x = SCREEN_W/2;
   main_menu->element[MENU_NEW_GAME_DUEL_CLASSIC].pos.y = SCREEN_H/2 + MENU_NEW_GAME_DUEL_CLASSIC*20 + OFFSET_MENU;
   main_menu->element[MENU_NEW_GAME_DUEL_CLASSIC].name_pos = CENTRE;
   
   strcpy(main_menu->element[MENU_NEW_GAME_DUEL_2AI].name, "Computer vs Computer");
   strcpy(main_menu->element[MENU_NEW_GAME_DUEL_2AI].des, "Admire their perfection!");
   main_menu->element[MENU_NEW_GAME_DUEL_2AI].pos.x = SCREEN_W/2;
   main_menu->element[MENU_NEW_GAME_DUEL_2AI].pos.y = SCREEN_H/2 + MENU_NEW_GAME_DUEL_2AI*20 + OFFSET_MENU;
   main_menu->element[MENU_NEW_GAME_DUEL_2AI].name_pos = CENTRE;   

   strcpy(main_menu->element[MENU_NEW_GAME_DUEL_2P].name, "Human vs Human");
   strcpy(main_menu->element[MENU_NEW_GAME_DUEL_2P].des, "Let's start the duel boys!");
   main_menu->element[MENU_NEW_GAME_DUEL_2P].pos.x = SCREEN_W/2;
   main_menu->element[MENU_NEW_GAME_DUEL_2P].pos.y = SCREEN_H/2 + MENU_NEW_GAME_DUEL_2P*20 + OFFSET_MENU;
   main_menu->element[MENU_NEW_GAME_DUEL_2P].name_pos = CENTRE;

   strcpy(main_menu->element[MENU_NEW_GAME_2P_VS_AI].name, "Two Humans vs Computer");
   strcpy(main_menu->element[MENU_NEW_GAME_2P_VS_AI].des, "Even two players have no chance to win...");
   main_menu->element[MENU_NEW_GAME_2P_VS_AI].pos.x = SCREEN_W/2;
   main_menu->element[MENU_NEW_GAME_2P_VS_AI].pos.y = SCREEN_H/2 + MENU_NEW_GAME_2P_VS_AI*20 +OFFSET_MENU;
   main_menu->element[MENU_NEW_GAME_2P_VS_AI].name_pos = CENTRE;

   strcpy(main_menu->element[MENU_OPTIONS].name, "Options");
   strcpy(main_menu->element[MENU_OPTIONS].des, "Do you have something to fix?");
   main_menu->element[MENU_OPTIONS].pos.x = SCREEN_W/2;
   main_menu->element[MENU_OPTIONS].pos.y = SCREEN_H/2 + MENU_OPTIONS*20 + OFFSET_MENU;
   main_menu->element[MENU_OPTIONS].name_pos = CENTRE;      

   strcpy(main_menu->element[MENU_QUIT_THE_GAME].name, "Quit");
   strcpy(main_menu->element[MENU_QUIT_THE_GAME].des, "See you later!");
   main_menu->element[MENU_QUIT_THE_GAME].pos.x = SCREEN_W/2;
   main_menu->element[MENU_QUIT_THE_GAME].pos.y = SCREEN_H/2 + MENU_QUIT_THE_GAME*20 + OFFSET_MENU;
   main_menu->element[MENU_QUIT_THE_GAME].name_pos = CENTRE;      
   
   fprintf(fp, "Main menu : OK\n");
   
   
   
   //Maintenant, le menu des options!
   
   option_menu = malloc(sizeof(TPONG_MENU));
   if (!option_menu) {
      fprintf(fp, "Not enough RAM to create a menu!\n");
      return FALSE;
   }
   option_menu->nb_elements = OPTION_MENU_NB_SELECTIONS;
   option_menu->cur_selection = 0;

   option_menu->element = malloc(sizeof(TPONG_MENU_ELEMENT)*option_menu->nb_elements);
   if (!option_menu->element) {
      fprintf(fp, "Not enough RAM to create menu's elements!\n");
      return FALSE;
   }

#define OFFSET_MENU_OPTION -75

   strcpy(option_menu->element[OPTION_MENU_DEFINE_GAME_MODE].name, "Game mode");
   strcpy(option_menu->element[OPTION_MENU_DEFINE_GAME_MODE].des,"Choose a game mode");
   option_menu->element[OPTION_MENU_DEFINE_GAME_MODE].pos.x = SCREEN_W/2;
   option_menu->element[OPTION_MENU_DEFINE_GAME_MODE].pos.y = SCREEN_H/2-80; //+ OPTION_MENU_DEFINE_GAME_MODE*20;
   option_menu->element[OPTION_MENU_DEFINE_GAME_MODE].name_pos = RIGHT;
     
   strcpy(option_menu->element[OPTION_MENU_PL].name, "Single player");
   strcpy(option_menu->element[OPTION_MENU_PL].des,"Redefine single player's keys");
   option_menu->element[OPTION_MENU_PL].pos.x = SCREEN_W/2;
   option_menu->element[OPTION_MENU_PL].pos.y = SCREEN_H/2 + OPTION_MENU_PL*40 + OFFSET_MENU_OPTION;
   option_menu->element[OPTION_MENU_PL].name_pos = RIGHT;
   
   strcpy(option_menu->element[OPTION_MENU_PL1].name, "Left-hand player");
   strcpy(option_menu->element[OPTION_MENU_PL1].des,"Redefine left-hand player's keys");
   option_menu->element[OPTION_MENU_PL1].pos.x = SCREEN_W/2;
   option_menu->element[OPTION_MENU_PL1].pos.y = SCREEN_H/2 + OPTION_MENU_PL1*40  + OFFSET_MENU_OPTION;
   option_menu->element[OPTION_MENU_PL1].name_pos = RIGHT;   
   
   strcpy(option_menu->element[OPTION_MENU_PL2].name, "Right-hand player");
   strcpy(option_menu->element[OPTION_MENU_PL2].des,"Redefine right-hand player's keys");
   option_menu->element[OPTION_MENU_PL2].pos.x = SCREEN_W/2;
   option_menu->element[OPTION_MENU_PL2].pos.y = SCREEN_H/2 + OPTION_MENU_PL2*40  + OFFSET_MENU_OPTION;
   option_menu->element[OPTION_MENU_PL2].name_pos = RIGHT;   
   
   strcpy(option_menu->element[OPTION_MENU_RETURN].name, "Return to main menu");
   strcpy(option_menu->element[OPTION_MENU_RETURN].des,"All set!");
   option_menu->element[OPTION_MENU_RETURN].pos.x = SCREEN_W/2;
   option_menu->element[OPTION_MENU_RETURN].pos.y = SCREEN_H - 40;
   option_menu->element[OPTION_MENU_RETURN].name_pos = CENTRE;   

   fprintf(fp, "Option menu : OK\n");

  //Maintenant, le menu des modes de jeu!
   
   mode_selector_menu = malloc(sizeof(TPONG_MENU));
   if (!mode_selector_menu) {
      fprintf(fp, "Not enough RAM to create a menu!\n");
      return FALSE;
   }
   mode_selector_menu->nb_elements = MODE_SELECTOR_MENU_NB_SELECTIONS;
   mode_selector_menu->cur_selection = 0;

   mode_selector_menu->element = malloc(sizeof(TPONG_MENU_ELEMENT)*mode_selector_menu->nb_elements);
   if (!mode_selector_menu->element) {
      fprintf(fp, "Not enough RAM to create menu's elements!\n");
      return FALSE;
   }
     
   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_REGULAR].name, "Regular");
   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_REGULAR].des,"Easiest mode - not that easy though");
   mode_selector_menu->element[MODE_SELECTOR_MENU_REGULAR].pos.x = SCREEN_W/2;
   mode_selector_menu->element[MODE_SELECTOR_MENU_REGULAR].pos.y = SCREEN_H/2 + MODE_SELECTOR_MENU_REGULAR*30 + OFFSET_MENU;
   mode_selector_menu->element[MODE_SELECTOR_MENU_REGULAR].name_pos = CENTRE;

   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_HARD].name, "Hard");
   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_HARD].des, "'Hard' is an understatement");
   mode_selector_menu->element[MODE_SELECTOR_MENU_HARD].pos.x = SCREEN_W/2;
   mode_selector_menu->element[MODE_SELECTOR_MENU_HARD].pos.y = SCREEN_H/2 + MODE_SELECTOR_MENU_HARD*30 + OFFSET_MENU;
   mode_selector_menu->element[MODE_SELECTOR_MENU_HARD].name_pos = CENTRE;

   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_UNLIMITED].name, "! Unlimited Speed !");
   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_UNLIMITED].des, "It's your neck...");
   mode_selector_menu->element[MODE_SELECTOR_MENU_UNLIMITED].pos.x = SCREEN_W/2;
   mode_selector_menu->element[MODE_SELECTOR_MENU_UNLIMITED].pos.y = SCREEN_H/2 + MODE_SELECTOR_MENU_UNLIMITED*30 + OFFSET_MENU;
   mode_selector_menu->element[MODE_SELECTOR_MENU_UNLIMITED].name_pos = CENTRE;

   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_RETURN].name, "Return to option menu");
   strcpy(mode_selector_menu->element[MODE_SELECTOR_MENU_RETURN].des, "Uh, I forgot what it was set to before...");
   mode_selector_menu->element[MODE_SELECTOR_MENU_RETURN].pos.x = SCREEN_W/2;
   mode_selector_menu->element[MODE_SELECTOR_MENU_RETURN].pos.y = SCREEN_H/2 + MODE_SELECTOR_MENU_RETURN*30+15 + OFFSET_MENU;
   mode_selector_menu->element[MODE_SELECTOR_MENU_RETURN].name_pos = CENTRE;

   fprintf(fp, "Mode selector menu : OK\n");

   return TRUE;
}

void load_options(void) {//charge les options
   int g_m;
   
   set_config_file("config//options.ini");   
   
   fprintf(fp, "Loading current mode...");
   
   g_m = get_config_int("game", "difficulty", 1);
 
   switch (g_m) {
      case 1:
         game.cur_level = &l_classic;
         break;
      case 2:
         game.cur_level = &l_hard;
         break;
      case 3:
         game.cur_level = &l_unlimited;
         break;
      default:
         game.cur_level = &l_classic;
   }

   fprintf(fp, "(%s)\n", game.cur_level->name);
 
   fprintf(fp, "Loading players configuration\n");
   
   single_player.key_up = get_config_int("single", "key_up",0);
   single_player.key_down = get_config_int("single", "key_down",0);
   
   left_player.key_up = get_config_int("left", "key_up",0);
   left_player.key_down = get_config_int("left", "key_down",0);

   right_player.key_up = get_config_int("right", "key_up",0);
   right_player.key_down = get_config_int("right", "key_down",0);

   fprintf(fp, "Single player: %s, %s\n", key_names[single_player.key_up], key_names[single_player.key_down]);
   fprintf(fp, "Left-hand player: %s, %s\n", key_names[left_player.key_up], key_names[left_player.key_down]);
   fprintf(fp, "Right-hand player: %s, %s\n", key_names[right_player.key_up], key_names[right_player.key_down]);
   
   return;
}

void save_options(void) { //sauve les options
   set_config_file("config//options.ini");   
  
   fprintf(fp, "Saving current game mode\n");
   
   set_config_int("game", "difficulty", game.cur_level->index);
   
   fprintf(fp, "Saving players configuration\n");
   
   set_config_int("single", "key_up", single_player.key_up);
   set_config_int("single", "key_down", single_player.key_down);
   
   set_config_int("left", "key_up", left_player.key_up);
   set_config_int("left", "key_down", left_player.key_down);

   set_config_int("right", "key_up", right_player.key_up);
   set_config_int("right", "key_down", right_player.key_down);
   return;
}

//mets en place les niveaux de jeu
void init_levels(void) {

   l_classic.max_ball_speed.x = 0.75;   //le mode classique avec la vitesses des versions <= 3
   l_classic.max_ball_speed.y = 0.75;
   l_classic.index = 1;
   strcpy(l_classic.high_score.path_name, "scores.sco");
   l_classic.high_score.nb_high_score_entries = SIZE_HIGH_SCORE_TABLE;
   
   strcpy(l_classic.name, "Regular");
   l_classic.logo_bitmap = (BITMAP*)(data_sprite[NUCLEAR1_BMP].dat);
   
   l_hard.max_ball_speed.x = 1.25;      //Nouveau et bien plus dur que classique (l'ordi ne perd pas)
   l_hard.max_ball_speed.y = 1.10;
   l_hard.index = 2;   
   strcpy(l_hard.high_score.path_name, "scoresh.sco");
   strcpy(l_hard.name, "Hard");
   l_hard.logo_bitmap = (BITMAP*)(data_sprite[NUCLEAR2_BMP].dat);
   l_hard.high_score.nb_high_score_entries = SIZE_HIGH_SCORE_TABLE;   
      
   l_unlimited.max_ball_speed.x = NOT_DEFINED;   //Pas de limites de vitesses de la balle ! ;) ouaf ouaf ouaf, le mode des paranos (ou blass mais ca m'tonnerait)
   l_unlimited.max_ball_speed.y = NOT_DEFINED;   //Pas de limites de vitesses de la balle ! ;) ouaf ouaf ouaf, le mode des paranos (ou blass mais ca m'tonnerait)
   l_unlimited.index = 3;
   strcpy(l_unlimited.high_score.path_name, "scoresu.sco");   
   strcpy(l_unlimited.name, "! Unlimited speed !");   
   l_unlimited.logo_bitmap = (BITMAP*)(data_sprite[NUCLEAR3_BMP].dat);
   l_unlimited.high_score.nb_high_score_entries = SIZE_HIGH_SCORE_TABLE;   
   
   
   //lit les scores de chaque fichier
   //s'il ne les trouve pas, il cre une table vierge
   packfile_password("temp");
   
   l_classic.high_score.high_score_entry = load_scores(l_classic.high_score.path_name, &(l_classic.high_score.nb_high_score_entries));
   l_hard.high_score.high_score_entry = load_scores(l_hard.high_score.path_name, &(l_hard.high_score.nb_high_score_entries));
   l_unlimited.high_score.high_score_entry = load_scores(l_unlimited.high_score.path_name, &(l_unlimited.high_score.nb_high_score_entries));
   
   packfile_password(NULL);

   return;
}


//Intialise les effets spciaux
STARS initialize_stars() {
   STARS s;
   int i;
   
   s.nb_stars = NB_GAME_STARS;                 //Le nombre d'toiles. Plus il y en a
   s.star = malloc(sizeof(VECTOR_3D)*s.nb_stars);
   if (!s.star) {
      fprintf(fp, "MEM ERROR");
      exit(1);
   }
   
   for (i = 0; i < s.nb_stars; ++i) {
      s.star[i].x = (rand() % STAR_START_RADIUS_X)-STAR_START_RADIUS_X/2;
      s.star[i].y = (rand() % STAR_START_RADIUS_Y)-STAR_START_RADIUS_Y/2;
      s.star[i].z = (rand() % (STAR_START_Z));
   }
   s.star_speed = STAR_START_SPEED;         //la vitesse !
   return s;
}


void function_close_window(void) {
   close_state = TRUE;
}